//
//  TransactionUIControlManager.swift
//  SampleApp
//
//  Created by Apple on 25/09/19.
//  Copyright © 2019 None. All rights reserved.
//

import Foundation
import UIKit

func setGradientBackgroundWithShadow(buttonBounds: CGRect) -> CAGradientLayer {
    let gradientLayer = CAGradientLayer()
    gradientLayer.cornerRadius = 5
    gradientLayer.frame = buttonBounds
    gradientLayer.colors = [#colorLiteral(red: 0.02803416736, green: 0.6146276593, blue: 0.9531614184, alpha: 1).cgColor,#colorLiteral(red: 0.085551925, green: 0.5000404119, blue: 0.7664285302, alpha: 1).cgColor]
    gradientLayer.locations = [0.0, 1.0]
    gradientLayer.startPoint = CGPoint(x:1.0,y:1.0)
    gradientLayer.endPoint = CGPoint(x: 0.0, y:0.0)
    gradientLayer.shadowColor = #colorLiteral(red: 0.02803416736, green: 0.6146276593, blue: 0.9531614184, alpha: 1)
    gradientLayer.shadowRadius = 5
    gradientLayer.shadowOpacity = 0.5
    gradientLayer.shadowOffset = CGSize(width: 0, height: 0)
    return gradientLayer
    }
